import React, { useEffect, useRef, useState } from "react";
import { Link } from "react-router-dom";
import Slider, { slickGoTo } from "react-slick";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";
import MainSiteHeader from "../../components/MainSiteHeader";
import MainSiteFooter from "../../components/MainSiteFooter";
import GalleryAnchor from "../../assets/img/gallery/gallery-anchor.jpg";
import Panel1 from "../../assets/img/gallery/gallery-1.jpg";
import Panel2 from "../../assets/img/gallery/gallery-2.jpg";
import Panel3 from "../../assets/img/gallery/gallery-3.jpg";
import Panel4 from "../../assets/img/gallery/gallery-4.jpg";
import Panel5 from "../../assets/img/gallery/gallery-5.jpg";
import Panel6 from "../../assets/img/gallery/gallery-6.jpg";
import Panel7 from "../../assets/img/gallery/gallery-7.jpg";
import Panel8 from "../../assets/img/gallery/gallery-8.jpg";
import Panel9 from "../../assets/img/gallery/gallery-9.jpg";
import Panel10 from "../../assets/img/gallery/gallery-10.jpg";
import Panel11 from "../../assets/img/gallery/gallery-11.jpg";
import Panel12 from "../../assets/img/gallery/gallery-12.jpg";
import Panel13 from "../../assets/img/gallery/gallery-13.jpg";
import Panel14 from "../../assets/img/gallery/gallery-14.jpg";
import Panel15 from "../../assets/img/gallery/gallery-15.jpg";
import Panel16 from "../../assets/img/gallery/gallery-16.jpg";
import Panel17 from "../../assets/img/gallery/gallery-17.jpg";
import Panel18 from "../../assets/img/gallery/gallery-18.jpg";
import Panel19 from "../../assets/img/gallery/gallery-19.jpg";
import './gallery.css';
import ActiveDot from "../../assets/img/home/homepage-slider-menu-navy.svg";
import Dot from "../../assets/img/home/homepage-slider-menu-beidge.svg";

const Gallery = () => {
  const [slideIndex, setSlideIndex] = useState(0);
  let sliderRef1 = useRef(null);
  const settings = {
    dots: false,
    infinite: true,
	fade: true,
	arrow: false,
	autoplay: true,
    speed: 800,
    slidesToShow: 1,
    slidesToScroll: 1,
    beforeChange: (current, next) => setSlideIndex(next)
  };
	function handleBoxClick(elem, panelgroup) {
		const panels = document.querySelectorAll('.'+panelgroup);
		panels.forEach((panel) => {
			panel.classList.remove('active');
		});
		document.getElementById(elem).classList.add('active');
	}
	
  return (
    <div className="relative w-full">
		<MainSiteHeader designSrc={GalleryAnchor}/>	

		<div className="relative pt-[50px]">
			<Slider
				ref={slider => {
				  sliderRef1 = slider;
				}}
				{...settings}
			  >
				<div>
					<div className="flex flex-row gap-2 mb-[50px]">
						
						<div className="relative cursor-pointer transition-all duration-500 panel" id="panel1" onClick={() => (handleBoxClick("panel1", "panel"))}>
							<img src={Panel2} />
							<h4>Safeway</h4>
							<div className="img-overlay"></div>
						</div>	
						<div className="relative cursor-pointer transition-all duration-500 panel" id="panel2" onClick={() => (handleBoxClick("panel2", "panel"))}>
							<img src={Panel3} />
							<h4>Shopping</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel active" id="panel3" onClick={() => (handleBoxClick("panel3", "panel"))}>
							<img src={Panel1} />
							<h4>VanDusen Botanical Garden</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel" id="panel4" onClick={() => (handleBoxClick("panel4", "panel"))}>
							<img src={Panel4} />
							<h4>Marpole</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel" id="panel5" onClick={() => (handleBoxClick("panel5", "panel"))}>
							<img src={Panel5} />
							<h4>Red Star Seafood Restaurant</h4>
							<div className="img-overlay"></div>
						</div>
					</div>
				</div>
				<div>
					<div className="flex flex-row gap-2 mb-[50px]">
						<div className="relative cursor-pointer transition-all duration-500 panel2 active" id="panel6" onClick={() => (handleBoxClick("panel6", "panel2"))}>
							<img src={Panel6} />
							<h4>Magee Secondary School</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel2" id="panel7" onClick={() => (handleBoxClick("panel7", "panel2"))}>
							<img src={Panel7} />
							<h4>Churchill Secondary School</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel2" id="panel8" onClick={() => (handleBoxClick("panel8", "panel2"))}>
							<img src={Panel8} />
							<h4>Marine Gateway</h4>
							<div className="img-overlay"></div>
						</div>	
						<div className="relative cursor-pointer transition-all duration-500 panel2" id="panel9" onClick={() => (handleBoxClick("panel9", "panel2"))}>
							<img src={Panel9} />
							<h4>Cycling along Bike Trails</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel2" id="panel10" onClick={() => (handleBoxClick("panel10", "panel2"))}>
							<img src={Panel10} />
							<h4>Marine Gateway</h4>
							<div className="img-overlay"></div>
						</div>	
					</div>
				</div>
				<div>
					<div className="flex flex-row gap-2 mb-[50px]">
						<div className="relative cursor-pointer transition-all duration-500 panel3 active" id="panel11" onClick={() => (handleBoxClick("panel11", "panel3"))}>
							<img src={Panel11} />
							<h4>T&T Supermarket</h4>
							<div className="img-overlay"></div>
						</div>	
						<div className="relative cursor-pointer transition-all duration-500 panel3" id="panel12" onClick={() => (handleBoxClick("panel12", "panel3"))}>
							<img src={Panel12} />
							<h4>Langara Golf Course</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel3" id="panel13" onClick={() => (handleBoxClick("panel13", "panel3"))}>
							<img src={Panel13} />
							<h4>Golfing at your Doorstep</h4>
							<div className="img-overlay"></div>
						</div>	
						<div className="relative cursor-pointer transition-all duration-500 panel3" id="panel14" onClick={() => (handleBoxClick("panel14", "panel3"))}>
							<img src={Panel14} />
							<h4>Queen Elizabeth Park</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel3" id="panel15" onClick={() => (handleBoxClick("panel15", "panel3"))}>
							<img src={Panel15} />
							<h4>Queen Elizabeth Park</h4>
							<div className="img-overlay"></div>
						</div>
					</div>
				</div>
				<div>
					<div className="flex flex-row gap-2 mb-[50px]">
						<div className="relative cursor-pointer transition-all duration-500 panel4 active" id="panel16" onClick={() => (handleBoxClick("panel16", "panel4"))}>
							<img src={Panel16} />
							<h4>Queen Elizabeth Park</h4>
							<div className="img-overlay"></div>
						</div>	
						<div className="relative cursor-pointer transition-all duration-500 panel4" id="panel17" onClick={() => (handleBoxClick("panel17", "panel4"))}>
							<img src={Panel17} />
							<h4>McArthurGlen Designer Outlet</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel4" id="panel18" onClick={() => (handleBoxClick("panel18", "panel4"))}>
							<img src={Panel18} />
							<h4>McArthurGlen Designer Outlet</h4>
							<div className="img-overlay"></div>
						</div>	
						<div className="relative cursor-pointer transition-all duration-500 panel4" id="panel19" onClick={() => (handleBoxClick("panel19", "panel4"))}>
							<img src={Panel19} />
							<h4>McArthurGlen Designer Outlet</h4>
							<div className="img-overlay"></div>
						</div>	
					</div>
				</div>
				
			</Slider>
		</div>
		<div className="relative my-0 mx-auto flex flex-row gap-2 justify-center pb-[50px]">
			<img className="w-[30px] cursor-pointer" src={slideIndex === 0 ? ActiveDot : Dot} onClick={() => (sliderRef1.slickGoTo(0))}></img>
			<img className="w-[30px] cursor-pointer" src={slideIndex === 1 ? ActiveDot : Dot} onClick={() => (sliderRef1.slickGoTo(1))}></img>
			<img className="w-[30px] cursor-pointer" src={slideIndex === 2 ? ActiveDot : Dot} onClick={() => (sliderRef1.slickGoTo(2))}></img>
			<img className="w-[30px] cursor-pointer" src={slideIndex === 3 ? ActiveDot : Dot} onClick={() => (sliderRef1.slickGoTo(3))}></img>
		</div>  
		<MainSiteFooter />
	</div>
  );
};

export default Gallery;